<?php
// ==================================================================
// Theme stylesheets
// ==================================================================
function ace_theme_styles() { 
  wp_enqueue_script('jquery');
  wp_enqueue_script('jquery-ui-widget');
  wp_enqueue_style( 'style', get_stylesheet_uri(), null, array(), 'all' );
  wp_enqueue_style( 'google-webfont', '//fonts.googleapis.com/css?family=PT+Serif:400,700,400italic,700italic|Montserrat:400,700', '', 'all' );
  if( is_singular() && esc_attr( get_option('thread_comments') ) ) wp_enqueue_script('comment-reply');
  wp_enqueue_script( 'respond', get_template_directory_uri() . '/js/respond.min.js', array( 'jquery' ), '1.3.0', true );
  wp_enqueue_script( 'scripts', get_template_directory_uri() . '/js/scripts.js', array( 'jquery' ), null, true );
}
add_action( 'wp_enqueue_scripts', 'ace_theme_styles' );

// ==================================================================
// Conditional scripts
// ==================================================================
function ace_conditional_scripts() { ?>
  <!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js" type="text/javascript"></script><![endif]-->
<?php }
add_action( 'wp_head', 'ace_conditional_scripts' );

// ==================================================================
// Add "Theme Options" on admin bar
// ==================================================================
function ace_admin_bar_menu() {
  global $wp_admin_bar;
  $home_url = get_home_url();
	if ( !is_super_admin() || !is_admin_bar_showing() )
  return;

	$wp_admin_bar->add_menu( array(
    'parent'  => 'appearance',
    'title'   => __( 'Theme Options','ace'),
    'href'    => ''.$home_url.'/wp-admin/themes.php?page=ace_options.php',
    'id'      => 'theme_options'
    ) );
}
add_action( 'admin_bar_menu', 'ace_admin_bar_menu', 100 );

// Theme Setup
// ====================================================================================================================================
function ace_theme_setup() {
// ====================================================================================================================================

  // ==================================================================
  // Custom header
  // ==================================================================
  add_theme_support( 'custom-header', array(
    'default-image'          => '',
    'random-default'         => false,
    'width'                  => 340,
    'height'                 => 85,
    'flex-height'            => true,
    'flex-width'             => true,
    'default-text-color'     => 'adcfb7',
    'header-text'            => true,
    'uploads'                => true,
    'wp-head-callback'       => '',
    'admin-head-callback'    => 'ace_admin_header_style',
    'admin-preview-callback' => 'ace_admin_header_image',
  ) );

  function ace_admin_header_style() { ?>
    <link href="//fonts.googleapis.com/css?family=PT+Serif:400,700,400italic,700italic|Montserrat:400,700" rel="stylesheet" type="text/css">
    <style type="text/css" id="ace-admin-header-css">
    .appearance_page_custom-header #headimg {
      background-color: #fff;
      padding: 30px 0;
      text-align: center;
    }
    #headimg h1 {
      font-family: 'Montserrat', Sans-serif;
      font-weight: 700;
      font-size: 46px;
      text-align: center;
      text-transform: uppercase;
      margin: 0;
    }
    #headimg h1 a {
      text-decoration: none;
    }
    #headimg h1 a:hover {
      color: #000;
    }
    #headimg .displaying-header-desc {
      font-family: 'PT Serif', Georgia, Times, Serif;
      font-weight: 400;
      font-size: 1.15em;
      text-align: center;
      color: #ccc;
      line-height: 1em;
    }
    #headimg img {
      vertical-align: middle;
      display: block;
      margin: 0 auto;
    }
    </style>
  <?php }

  function ace_admin_header_image() { ?>
    <div id="headimg">
      <?php if ( get_header_image() ) : ?>
      <img src="<?php header_image(); ?>" alt="">
      <?php else : ?>
      <h1 class="displaying-header-text"><a id="name"<?php echo sprintf( ' style="color:#%s;"', get_header_textcolor() ); ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
      <p class="displaying-header-text displaying-header-desc"><?php bloginfo( 'description' ); ?></p>
      <?php endif; ?>
    </div>
  <?php }

  function ace_header_image_text() {
  $text_color = get_header_textcolor();
  // If no custom color for text is set, let's bail.
  if ( display_header_text() && $text_color === get_theme_support( 'custom-header', 'default-text-color' ) )
  return;
  // If we get this far, we have custom styles.
  ?>
    <style type="text/css">
    <?php if ( !display_header_text() ) : ?>
      .header h1,
      .header h5,
      .header-desc {display: none;}
    <?php elseif ( $text_color != get_theme_support( 'custom-header', 'default-text-color' ) ) : ?>
      .header-title {color: #<?php echo esc_attr( $text_color ); ?>;}
    <?php endif; ?>
    </style>
  <?php
  }
  add_action( 'wp_head', 'ace_header_image_text' );

  // ==================================================================
  // Custom background
  // ==================================================================
  add_theme_support( 'custom-background', array( 'default-color' => 'ffffff' ) );

  // ==================================================================
  // Language
  // ==================================================================
  load_theme_textdomain( 'ace', get_template_directory() . '/languages' );

  // ==================================================================
  // Add default posts and comments RSS feed links to head
  // ==================================================================
  add_theme_support( 'automatic-feed-links' );

  // ==================================================================
  // Visual editor stylesheet
  // ==================================================================
  add_editor_style( 'editor.css' );

  // ==================================================================
  // Shortcode in excerpt
  // ==================================================================
  add_filter( 'the_excerpt', 'do_shortcode' );

  // ==================================================================
  // Shortcode in widget
  // ==================================================================
  add_filter( 'widget_text', 'do_shortcode' );

  // ==================================================================
  // Clickable link in content
  // ==================================================================
  add_filter( 'the_content', 'make_clickable' );

  // ==================================================================
  // Header title tag support
  // ==================================================================
  add_theme_support( 'title-tag' );

  // ==================================================================
  // HTML5 Support
  // ==================================================================
	add_theme_support( 'html5', array(
    'search-form',
    'comment-form',
    'comment-list',
    'gallery',
    'caption',
	) );

  // ==================================================================
  // Content width
  // ==================================================================
  if ( ! isset( $content_width ) ) $content_width = 840;

// Theme Setup
// ====================================================================================================================================
}
add_action( 'after_setup_theme', 'ace_theme_setup' );
// ====================================================================================================================================

// ==================================================================
// Remove auto format
// ==================================================================
function ace_formatter( $content ) {
	$new_content = '';
	$pattern_full = '{(\[raw\].*?\[/raw\])}is';
	$pattern_contents = '{\[raw\](.*?)\[/raw\]}is';
	$pieces = preg_split( $pattern_full, $content, -1, PREG_SPLIT_DELIM_CAPTURE );
	foreach ( $pieces as $piece ) {
		if ( preg_match( $pattern_contents, $piece, $matches ) ) {
			$new_content .= $matches[1];
		} else {
			$new_content .= wptexturize( wpautop( $piece ) );
		}
	}
	return $new_content;
}
//remove_filter( 'the_content', 'wpautop' );
//remove_filter( 'the_content', 'wptexturize' );
//add_filter( 'the_content', 'ace_formatter', 99 );
function raw_formatting( $atts, $content = null ) {
  // $content = parse_shortcode_content( $content );
  return do_shortcode( $content );
}
add_shortcode( 'raw', 'raw_formatting' );

// ==================================================================
// Comment time
// ==================================================================
function ace_time_ago( $type = 'comment' ) {
  $d = 'comment' == $type ? 'get_comment_time' : 'get_post_time';
  return human_time_diff( $d( 'U' ), current_time( 'timestamp' ) ) . " " . __( 'ago','ace' );
}

// ==================================================================
// Custom comment style
// ==================================================================
function comment_style( $comment, $args, $depth ) {
  $GLOBALS['comment'] = $comment; ?>
  <li <?php comment_class(); ?>>
    <article class="comment-content" id="comment-<?php comment_ID(); ?>">
      <div class="comment-meta">
        <?php echo get_avatar($comment, $size = '32' ); ?>
        <?php printf( __( '<h6>%s</h6>','ace' ), get_comment_author_link() ) ?>
        <small><?php printf( __( '%1$s at %2$s','ace' ), get_comment_date(), get_comment_time() ) ?> (<?php printf( __( '%s','ace' ), ace_time_ago() ) ?>)</small>
      </div>
    <?php if ( $comment->comment_approved == '0' ) : ?><em><?php _e( 'Your comment is awaiting moderation','ace' ) ?>.</em><br /><?php endif; ?>
    <?php comment_text() ?>
    <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ) ?>
    </article>
<?php }

// ==================================================================
// WordPress header title backward compatibility
// ==================================================================
if ( ! function_exists( '_wp_render_title_tag' ) ) :
  function ace_theme_render_title() {
  echo wp_title();
  }
  add_action( 'wp_head', 'ace_theme_render_title' );
endif;

// ==================================================================
// Add internal lightbox
// ==================================================================
function ace_add_themescript() {
  if ( !is_admin() ){
    wp_enqueue_script( 'jquery' );
    wp_enqueue_script( 'thickbox', null, array( 'jquery' ) );
  }
}
add_action( 'init','ace_add_themescript' );

function ace_wp_thickbox_script() {
  ?>
  <script type="text/javascript">
  if ( typeof tb_pathToImage != 'string' ) {
      var tb_pathToImage = "<?php echo site_url().'/wp-includes/js/thickbox'; ?>/loadingAnimation.gif";
    }
  if ( typeof tb_closeImage != 'string' ) {
      var tb_closeImage = "<?php echo site_url().'/wp-includes/js/thickbox'; ?>/tb-close.png";
    }
  </script>
  <?php
  wp_enqueue_style( 'thickbox.css', '/'.WPINC.'/js/thickbox/thickbox.css', null, '1.0' );
}
add_action( 'wp_head', 'ace_wp_thickbox_script' );

// ==================================================================
// Add colorbox
// ==================================================================
function ace_colorbox_replace( $content ) {
	$pattern = '/<a(.*?)href="(.*?).(bmp|gif|jpeg|jpg|png)"(.*?)>/i';
  $replacement = '<a$1href="$2.$3" rel="colorbox" class="colorbox"$4>';
	$content = preg_replace( $pattern, $replacement, $content );
	return $content;
}
add_filter( 'the_content', 'ace_colorbox_replace' );


function ace_add_colorbox_rel( $attachment_link ) {
  $attachment_link = str_replace( 'a href' , 'a rel="colorbox-cats" class="colorbox-cats" href' , $attachment_link );
  return $attachment_link;
}
add_filter( 'wp_get_attachment_link' , 'ace_add_colorbox_rel' );

function ace_colorbox_script(){
  wp_enqueue_style( 'colorbox', get_template_directory_uri() . '/js/colorbox/colorbox.css', null, array(), 'all' );
  wp_enqueue_script( 'colorbox', get_template_directory_uri() . '/js/colorbox/jquery.colorbox-min.js', array( 'jquery' ), null, true );
}
add_action( 'wp_enqueue_scripts', 'ace_colorbox_script' );

// ==================================================================
// Post/page pagination
// ==================================================================
function ace_get_link_pages() {
  wp_link_pages(
    array(
    'before'           => '<p class="page-pagination"><span class="page-pagination-title">' . __('Pages:','ace') . '</span>',
    'after'            => '</p>',
    'link_before'      => '<span class="page-pagination-number">',
    'link_after'       => '</span>',
    'next_or_number'   => 'number',
    'nextpagelink'     => __( 'Next page','ace' ),
    'previouspagelink' => __( 'Previous page','ace' ),
    'pagelink'         => '%',
    'echo'             => 1
    )
  );
}

// ==================================================================
// Pagination (WordPress)
// ==================================================================
function get_pagination_links() {
  global $wp_query;
  $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
  $big = 999999999;
  return paginate_links( array(
    'base' => @add_query_arg( 'paged','%#%' ),
    'format' => '?paged=%#%',
    'current' => $current,
    'total' => $wp_query->max_num_pages,
    'prev_next'    => true,
    'prev_text'    => __( 'Previous','ace' ),
    'next_text'    => __( 'Next','ace' ),
  ) );
}

// ==================================================================
// Jetpack and Colorbox conflict
// ==================================================================
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if (is_plugin_active( 'jetpack/jetpack.php' ) ) {
  remove_action( 'init','ace_add_themescript' );
  remove_action( 'wp_head', 'ace_wp_thickbox_script' );
  remove_filter( 'wp_get_attachment_link' , 'ace_add_colorbox_rel' );
  remove_action( 'wp_head', 'ace_colorbox_javascript' );
  remove_action( 'wp_footer', 'ace_colorbox_script' );
}