<?php
// ==================================================================
// Heading
// ==================================================================
function estelle_heading() {
  if( get_header_image() == true ) { ?>
    <a href="<?php echo esc_url( home_url() ); ?>">
      <img src="<?php header_image(); ?>" class="aligncenter" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="<?php bloginfo( 'name' ); ?>" title="<?php bloginfo( 'name' ); ?>" />
    </a>
  <?php } elseif( is_home() || is_front_page() ) { ?>
      <h1><a href="<?php echo esc_url( home_url() ); ?>" class="header-title"><?php bloginfo( 'name' ); ?></a></h1>
      <p class="header-desc"><?php bloginfo( 'description' ); ?></p>
  <?php } else { ?>
      <h5><a href="<?php echo esc_url( home_url() ); ?>" class="header-title"><?php bloginfo( 'name' ); ?></a></h5>
      <p class="header-desc"><?php bloginfo( 'description' ); ?></p>
  <?php }
}

// ==================================================================
// Header Banner
// ==================================================================
function estelle_header_banner_style(){
  if( get_option( 'estelle_header_bg' ) ) { ?>

    <style type="text/css">
    .header {
      background-image: url('<?php if( get_option( 'estelle_header_bg' ) ) { echo stripslashes( get_option( 'estelle_header_bg' ) ); } else { echo get_template_directory_uri(); echo '/images/desktop.jpg';} ?>');
      background-size: cover;
      background-position: center center;
    }
    </style>

  <?php }
}
add_action( 'wp_head', 'estelle_header_banner_style' );