<?php
// ==================================================================
// Theme scripts
// ==================================================================
function estelle_theme_scripts(){
  wp_enqueue_script( 'jquery' );
  wp_enqueue_script( 'jquery-ui-widget' );
  wp_enqueue_style( 'style', get_stylesheet_uri(), null, array(), 'all' );
  wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/fontawesome/css/font-awesome.min.css', null, array(), 'all' );
  wp_enqueue_style( 'google-webfont', '//fonts.googleapis.com/css?family=Lato:300,400,700,900,300italic,400italic,700italic,900italic', '', 'all' );
  if( is_singular() && comments_open() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );
  wp_enqueue_script( 'respond', get_template_directory_uri() . '/js/respond.min.js', array( 'jquery' ), '1.3.0', true );
  wp_enqueue_script( 'fitvids', get_template_directory_uri() . '/js/fitvids.min.js', array( 'jquery' ), '1.1', true );
  wp_enqueue_script( 'doubletaptogo', get_template_directory_uri() . '/js/doubletaptogo.min.js', array( 'jquery' ), null, true );
  wp_enqueue_script( 'tinynav', get_template_directory_uri() . '/js/tinynav.min.js', array( 'jquery' ), '1.2', true );
  wp_enqueue_script( 'scripts', get_template_directory_uri() . '/js/scripts.js', array( 'jquery' ), null, true );
}
add_action( 'wp_enqueue_scripts', 'estelle_theme_scripts' );

// ==================================================================
// Add "Theme Options" on admin bar
// ==================================================================
function estelle_admin_bar_menu() {
  global $wp_admin_bar;
  $home_url = get_home_url();
	if( !is_super_admin() || !is_admin_bar_showing() )
  return;
	$wp_admin_bar->add_menu( array(
    'parent'  => 'appearance',
    'title'   => __( 'Theme Options', 'estelle' ),
    'href'    => ''.$home_url.'/wp-admin/themes.php?page=estelle_options.php',
    'id'      => 'theme_options'
    ) );
}
add_action( 'admin_bar_menu', 'estelle_admin_bar_menu', 100 );

// ==================================================================
// Mobile menu
// ==================================================================
function estelle_mobile_menu_scripts() {
  ?>
  <script type="text/javascript">
  /* <![CDATA[ */
  jQuery( document ).ready( function( $ ){ // START
    // Mobile menu
    $( 'nav.nav .menu ul' ).tinyNav({
      header: '<?php _e( 'Navigate to...', 'estelle' ); ?>',
      active: 'current_page_item, current-menu-item'
    });
  }); // END
  /* ]]> */
  </script>
  <?php
}
add_action( 'wp_footer', 'estelle_mobile_menu_scripts' );

// ==================================================================
// Content width
// ==================================================================
if ( ! isset( $content_width ) )
	$content_width = 660;

// Theme Setup
// ====================================================================================================================================
function estelle_theme_setup() {
// ====================================================================================================================================

  // ==================================================================
  // Custom header
  // ==================================================================
  add_theme_support( 'custom-header', array(
    'default-image'          => '',
    'random-default'         => false,
    'width'                  => 200,
    'height'                 => 75,
    'flex-height'            => true,
    'flex-width'             => true,
    'default-text-color'     => '888888',
    'header-text'            => true,
    'uploads'                => true,
    'wp-head-callback'       => '',
    'admin-head-callback'    => 'estelle_admin_header_style',
    'admin-preview-callback' => 'estelle_admin_header_image',
  ) );

  function estelle_admin_header_style() { ?>
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,400,700|Oswald:400,700" rel="stylesheet" type="text/css">
    <style type="text/css">
    .appearance_page_custom-header #headimg {
      background-color: #fff;
      padding: 10px;
      text-align: center;
    }
    #headimg h1 {
      font-family: 'Open Sans', Arial, Verdana, Tahoma, Sans-serif;
      font-size: 52px;
      font-weight: 400;
      margin: 10px 0 0 0;
      text-align: center;
      text-transform: uppercase;
      letter-spacing: .05em;
    }
    #headimg h1 a {
      text-decoration: none;
    }
    #headimg .displaying-header-desc {
      font-size: .9em;
      margin: 0;
      text-align: center;
      text-transform: uppercase;
      letter-spacing: .1em
    }
    #headimg img {
      vertical-align: middle;
      display: block;
      margin: 0 auto;
    }
    </style>

  <?php }

  function estelle_admin_header_image() { ?>
    <div id="headimg">
      <?php if( get_header_image() ) : ?>
      <img src="<?php header_image(); ?>" alt="">
      <?php else : ?>
      <h1 class="displaying-header-text"><a id="name"<?php echo sprintf( ' style="color:#%s;"', get_header_textcolor() ); ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
      <p class="displaying-header-text displaying-header-desc"><?php bloginfo( 'description' ); ?></p>
      <?php endif; ?>
    </div>
  <?php }

  function estelle_header_image_text() {
  $text_color = get_header_textcolor();
  // If no custom color for text is set, let's bail.
  if( display_header_text() && $text_color === get_theme_support( 'custom-header', 'default-text-color' ) )
  return;
  // If we get this far, we have custom styles.
  ?>
    <style type="text/css">
    <?php if( !display_header_text() ) : ?>
      .header h1,
      .header h5,
      .header-desc {display: none;}
    <?php elseif( $text_color != get_theme_support( 'custom-header', 'default-text-color' ) ) : ?>
      .header-title {color: #<?php echo esc_attr( $text_color ); ?>;}
    <?php endif; ?>
    </style>
  <?php
  }
  add_action( 'wp_head', 'estelle_header_image_text' );

  // ==================================================================
  // Custom background
  // ==================================================================
  add_theme_support( 'custom-background', array( 'default-color' => 'ffffff' ) );

  // ==================================================================
  // Language
  // ==================================================================
  load_theme_textdomain( 'estelle', get_template_directory() . '/languages' );

  // ==================================================================
  // Add default posts and comments RSS feed links to head
  // ==================================================================
  add_theme_support( 'automatic-feed-links' );

  // ==================================================================
  // Menu location
  // ==================================================================
  register_nav_menu( 'top_menu', __( 'Top Menu', 'estelle' ) );

  // ==================================================================
  // Visual editor stylesheet
  // ==================================================================
  add_editor_style( 'editor.css' );

  // ==================================================================
  // Clickable link in content
  // ==================================================================
  add_filter( 'the_content', 'make_clickable' );

  // ==================================================================
  // Remove version generator
  // ==================================================================
  remove_action( 'wp_head', 'wp_generator' );

  // ==================================================================
  // Remove title on archive page
  // ==================================================================
  function ace_remove_archive_title_label( $title ) {
    if ( is_category() ) {
      $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
      $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
      $title = '<span class="vcard">' . get_the_author() . '</span>' ;
    } elseif ( is_year() ) {
      $title = sprintf( __( 'Year: %s', 'ace' ), get_the_date( _x( 'Y', 'yearly archives date format', 'ace' ) ) );
    } elseif ( is_month() ) {
      $title = sprintf( __( 'Month: %s', 'ace' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'ace' ) ) );
    } elseif ( is_day() ) {
      $title = sprintf( __( 'Day: %s', 'ace' ), get_the_date( _x( 'F j, Y', 'daily archives date format', 'ace' ) ) );
    }
  return $title;
  }
  add_filter( 'get_the_archive_title', 'ace_remove_archive_title_label');

  // ==================================================================
  // Add "Home" in menu
  // ==================================================================
  function estelle_home_page_menu( $args ) {
    $args[ 'show_home' ] = true;
    return $args;
  }
  add_filter( 'wp_page_menu_args', 'estelle_home_page_menu' );

  // ==================================================================
  // Header title tag support
  // ==================================================================
  add_theme_support( 'title-tag' );

  // ==================================================================
  // HTML5 Support
  // ==================================================================
	add_theme_support( 'html5', array(
    'search-form',
    'comment-form',
    'comment-list',
    'gallery',
    'caption',
	) );

// Theme Setup
// ====================================================================================================================================
}
add_action( 'after_setup_theme', 'estelle_theme_setup' );
// ====================================================================================================================================

// ==================================================================
// Custom comment style
// ==================================================================
function comment_style( $comment, $args, $depth ) {
  $GLOBALS[ 'comment' ] = $comment; ?>
  <li <?php comment_class(); ?>>
    <article class="comment-content" id="comment-<?php comment_ID(); ?>">
      <div class="comment-meta">
        <?php echo get_avatar( $comment, $size = '32' ); ?>
        <?php printf( __( '<h6>%s</h6>', 'estelle' ), get_comment_author_link() ) ?>
        <small><?php printf( __( '%1$s at %2$s', 'estelle' ), get_comment_date(), get_comment_time() ) ?></small>
      </div>
    <?php if( $comment->comment_approved == '0' ) : ?><em><?php _e( 'Your comment is awaiting moderation', 'estelle' ) ?>.</em><br /><?php endif; ?>
    <?php comment_text() ?>
    <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args[ 'max_depth' ] ) ) ) ?>
    </article>
<?php }

// ==================================================================
// WordPress header title backward compatibility
// ==================================================================
if ( ! function_exists( '_wp_render_title_tag' ) ) :
  function estelle_theme_render_title() {
  echo wp_title();
  }
  add_action( 'wp_head', 'estelle_theme_render_title' );
endif;

// ==================================================================
// Post/page pagination
// ==================================================================
function estelle_get_link_pages() {
  wp_link_pages(
    array(
    'before'           => '<p class="page-pagination"><span class="page-pagination-title">' . __( 'Pages:', 'estelle' ) . '</span>',
    'after'            => '</p>',
    'link_before'      => '<span class="page-pagination-number">',
    'link_after'       => '</span>',
    'next_or_number'   => 'number',
    'nextpagelink'     => __( 'Next page', 'estelle' ),
    'previouspagelink' => __( 'Previous page', 'estelle' ),
    'pagelink'         => '%',
    'echo'             => 1
    )
  );
}

// ==================================================================
// Pagination (WordPress)
// ==================================================================
function estelle_get_pagination_links() {
  the_posts_pagination( array(
    'mid_size'  => 5,
    'prev_text' => __( 'Previous', 'ace' ),
    'next_text' => __( 'Next', 'ace' ),
  ) );
}