<?php

//error_reporting(0);
$anthEpubDir = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'anthologize' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'epub' . DIRECTORY_SEPARATOR;
require_once( $anthEpubDir . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'class-epub-builder.php' );
include_once( ANTHOLOGIZE_TEIDOM_PATH );

$ops = array(
	'includeStructuredSubjects'    => false, // Include structured data about tags and categories
	'includeItemSubjects'          => false, // Include basic data about tags and categories
	'includeCreatorData'           => false, // Include basic data about creators
	'includeStructuredCreatorData' => false, // Include structured data about creators
	'includeOriginalPostData'      => true,  // Include data about the original post (true to use tags and categories)
	'checkImgSrcs'                 => true,  // Whether to check availability of image sources
	'linkToEmbeddedObjects'        => false, // Whether to replace embedded objects with a link to them
	'indexSubjects'                => false,
	'indexCategories'              => false,
	'indexTags'                    => false,
	'indexAuthors'                 => false,
	'indexImages'                  => false,
);

$ops['outputParams'] = anthologize_get_session_output_params();

if ( ! class_exists( 'XSLTProcessor', false ) ) {
	die( 'ePub export requires XSL support' );
}

// Set paths to include
$paths = array(
	dirname( __FILE__ ) . '/pear_ext',
	get_include_path()
);

// Set custom include path
set_include_path( implode( PATH_SEPARATOR, $paths ) );

// Require PEAR archive
require_once( 'Archive.php' );

// Load intermediate TEI file
// generated by anthologize/includes/class-tei-dom.php

$tei_data = new TeiDom( anthologize_get_session(), $ops );
$epub = new EpubBuilder( $tei_data, $anthEpubDir  . 'tei2html.xsl' );
//echo $epub->tei->getTeiString();
//echo $epub->html->saveHTML();
//die();
$epub->output();

//done!
die();
