<?php


include_once(ANTHOLOGIZE_TEIDOM_PATH);
include_once(ANTHOLOGIZE_TEIDOMAPI_PATH);

$ops = array('includeStructuredSubjects' => true, //Include structured data about tags and categories
		'includeItemSubjects' => true, // Include basic data about tags and categories
		'includeCreatorData' => true, // Include basic data about creators
		'includeStructuredCreatorData' => true, //include structured data about creators
		'includeOriginalPostData' => true, //include data about the original post (true to use tags and categories)
		'checkImgSrcs' => false, //whether to check availability of image sources
        'includeComments' => true,
		'linkToEmbeddedObjects' => false,
		'indexSubjects' => true,
		'indexCategories' => true,
		'indexTags' => true,
		'indexPeople' => true,
		'indexImages' => true,
		);

$ops['outputParams'] = anthologize_get_session_output_params();


$tei = new TeiDom( anthologize_get_session(), $ops );
$api = new TeiApi($tei);


//if you want to make it a download.
$fileName = $api->getFileName();
$ext = "xml";

header("Content-type: application/xml");
header("Content-Disposition: attachment; filename=$fileName.$ext");
echo $tei->getTeiString();


die();

