<?php
// ==================================================================
// START register theme customize
// ==================================================================
function ace_customize_register( $wp_customize ){

// ====================================================================================================================================
// Register customize panel
// ====================================================================================================================================
$wp_customize->add_panel( 'ace_theme_panel', array(
    'title' => 'Bluchic Theme',
    'description' => '',
    'priority' => 1000,
) );

// ====================================================================================================================================
// Register theme customize section
// ====================================================================================================================================
$wp_customize->add_section( 'ace_theme_setup', array(
  'title'       => __( 'General settings', 'ace' ),
  ''			=> 1001,
  'description' => '',
  'panel'       => 'ace_theme_panel',
) );
// ================================================================== Author signature
$wp_customize->add_setting( 'ace_content_image', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'ace_content_image', array(
  'label'      => __( 'Content image', 'ace' ),
  'section'    => 'ace_theme_setup',
  'settings'   => 'ace_content_image',
) ) );
// ================================================================== Content
$wp_customize->add_setting( 'ace_content', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( 'ace_content', array(
  'settings'  => 'ace_content',
  'label'     => __( 'Content', 'ace' ),
  'section'   => 'ace_theme_setup',
  'type'      => 'textarea',
) );
// ================================================================== Enable site progress bar
$wp_customize->add_setting( 'ace_site_progress_enable', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( 'ace_site_progress_enable', array(
  'settings'  => 'ace_site_progress_enable',
  'label'     => __( 'Enable progress bar on the site', 'ace' ),
  'section'   => 'ace_theme_setup',
  'type'      => 'checkbox',
) );
// ================================================================== Site progress
$wp_customize->add_setting( 'ace_site_progress', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( 'ace_site_progress', array(
  'settings'  => 'ace_site_progress',
  'label'     => __( 'Site progress', 'ace' ),
  'section'   => 'ace_theme_setup',
  'type'      => 'select',
  'choices'   => array(
    '10' => '10',
    '20' => '20',
    '30' => '30',
    '40' => '40',
    '50' => '50',
    '60' => '60',
    '70' => '70',
    '80' => '80',
    '90' => '90',
    '100' => '100',
  ),
) );
// ================================================================== Progress bar colour
$wp_customize->add_setting( 'ace_site_progress_color', array(
	'default'           =>  '#daeae0',
	'sanitize_callback' =>  'sanitize_hex_color',
	'type'              =>  'option',
	'capability'        =>  'edit_theme_options',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ace_site_progress_color', array(
	'label'     => __( 'Progress bar colour', 'ace' ),
	'section'   => 'ace_theme_setup',
	'settings'  => 'ace_site_progress_color',
) ) );
// ================================================================== Footer credit
$wp_customize->add_setting( 'ace_footer_credit', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ace_footer_credit', array(
  'label'     => __( 'Footer credit', 'ace' ),
  'section'   => 'ace_theme_setup',
  'settings'  => 'ace_footer_credit',
	'type'      => 'textarea',
) ) );


// ====================================================================================================================================
// Register theme customize section
// ====================================================================================================================================
$wp_customize->add_section( 'ace_theme_extra', array(
	'title'       => __( 'Extra inputs settings', 'ace' ),
	'priority'    => 1003,
  'description' => '',
  'panel'       => 'ace_theme_panel',
) );
// ================================================================== Header script(s)
$wp_customize->add_setting( 'ace_header_scripts', array(
  'default'           => '',
  'capability'        => 'edit_theme_options',
  'type'              => 'option',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ace_header_scripts', array(
  'label'     => __( 'Header script(s)', 'ace' ),
  'section'   => 'ace_theme_extra',
  'settings'  => 'ace_header_scripts',
	'type'      => 'textarea',
) ) );
// ================================================================== Footer script(s)
$wp_customize->add_setting( 'ace_footer_scripts', array(
  'default'           => '',
  'capability'        => 'edit_theme_options',
  'type'              => 'option',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ace_footer_scripts', array(
  'label'     => __( 'Footer script(s)', 'ace' ),
  'section'   => 'ace_theme_extra',
  'settings'  => 'ace_footer_scripts',
	'type'      => 'textarea',
) ) );
// ================================================================== Custom CSS
$wp_customize->add_setting( 'ace_css', array(
  'default'           => '',
  'capability'        => 'edit_theme_options',
  'type'              => 'option',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ace_css', array(
  'label'     => __( 'Custom CSS', 'ace' ),
  'section'   => 'ace_theme_extra',
  'settings'  => 'ace_css',
	'type'      => 'textarea',
) ) );

// ====================================================================================================================================
// Register theme customize section
// ====================================================================================================================================
$wp_customize->add_section( 'ace_theme_color', array(
	'title'       => __( 'Colors settings', 'ace' ),
	'priority'    => 1002,
  'description' => '',
  'panel'       => 'ace_theme_panel',
) );
// ==================================================================
// Color Assent
// ==================================================================
// ================================================================== Footer background
$wp_customize->add_setting( 'ace_footer_background', array(
	'default'           =>  '#fce2d3',
	'sanitize_callback' =>  'sanitize_hex_color',
	'type'              =>  'option',
	'capability'        =>  'edit_theme_options',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ace_footer_background', array(
	'label'     => __( 'Footer background color', 'ace' ),
	'section'   => 'ace_theme_color',
	'settings'  => 'ace_footer_background',
) ) );
// ================================================================== Footer text
$wp_customize->add_setting( 'ace_footer_text', array(
	'default'           =>  '#999999',
	'sanitize_callback' =>  'sanitize_hex_color',
	'type'              =>  'option',
	'capability'        =>  'edit_theme_options',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ace_footer_text', array(
	'label'     => __( 'Footer text color', 'ace' ),
	'section'   => 'ace_theme_color',
	'settings'  => 'ace_footer_text',
) ) );
// ================================================================== Footer link
$wp_customize->add_setting( 'ace_footer_link', array(
	'default'           =>  '#adcfb7',
	'sanitize_callback' =>  'sanitize_hex_color',
	'type'              =>  'option',
	'capability'        =>  'edit_theme_options',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ace_footer_link', array(
	'label'     => __( 'Footer link color', 'ace' ),
	'section'   => 'ace_theme_color',
	'settings'  => 'ace_footer_link',
) ) );

// ====================================================================================================================================
// Register theme customize section
// ====================================================================================================================================
$wp_customize->add_section( 'ace_theme_404', array(
	'title'       => __( '404 page settings', 'ace' ),
	'priority'    => 1008,
  'description' => '',
  'panel'       => 'ace_theme_panel',
) );
// ================================================================== 404 Error
$wp_customize->add_setting( 'ace_404_page', array(
  'capability'  => 'edit_theme_options',
  'type'        => 'option',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ace_404_page', array(
  'label'     => __( '404 Page Content', 'ace' ),
  'section'   => 'ace_theme_404',
  'settings'  => 'ace_404_page',
	'type'      => 'textarea',
) ) );


// ==================================================================
// END register theme customize
// ==================================================================
}
add_action( 'customize_register', 'ace_customize_register' );