    <article <?php post_class( 'article' ); ?> id="post-<?php the_ID(); ?>" itemscope itemtype="http://schema.org/CreativeWork">

      <header class="post-header">
        <h1 class="post-title entry-title" itemprop="headline"><a itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" href="<?php the_permalink(); ?>" rel="<?php esc_attr_e( 'bookmark', 'estelle' ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
        <ul class="post-meta">
          <li class="post-date"><span itemprop="dateModified"><time datetime="<?php the_time( get_option( 'date_format' ) ); ?>" itemprop="datePublished" class="updated"><?php the_time( get_option( 'date_format' ) ); ?></time></span></li>
          <li class="post-category"><?php the_category( ', ' ); ?></li>
          <li class="post-comment"><?php comments_popup_link( __( '0 comment', 'estelle' ), __( '1 Comment', 'estelle' ), __( '% Comments', 'estelle' ) ); ?></li>
        </ul><!-- .post-meta -->
      </header>

      <article class="post-content entry-content" itemprop="text">

        <?php the_content(); ?>

        <?php estelle_get_link_pages(); ?>

        <footer class="post-footer">
          <?php the_tags( '<p class="post-tags">Tags: ', ', ', '</p>' ); ?>
          <ul class="footer-navi">
            <?php previous_post_link( __( '<li class="previous" rel="prev">&laquo; %link</li>', 'estelle' ) ); ?>
            <?php next_post_link( __( '<li class="next" rel="next">%link &raquo;</li>', 'estelle' ) ); ?>
          </ul>
        </footer><!-- .post-footer -->

        <?php comments_template( '/comments.php', true ); ?>

      </article><!-- .post-content -->

    </article><!-- .article -->